/*
 * QtObservedMoleculeObserver.hpp
 *
 *  Created on: Mar 17, 2016
 *      Author: heber
 */


#ifndef QTOBSERVEDMOLECULEOBSERVER_HPP_
#define QTOBSERVEDMOLECULEOBSERVER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QWidget>

#include "UIElements/Qt4/InstanceBoard/QtObservedMolecule.hpp"
#include "types.hpp"

class QtObservedInstanceBoard;

/** This class serves all QtObservedMolecule instances and relays specific
 * events, such as ElementChanged.
 *
 * This is to have single class that is informed about all changes of a
 * certain type, but on the Qt side, just as EntityObserver does on the
 * molecuilder side.
 *
 */
class QtObservedMoleculeObserver : public QWidget
{
  Q_OBJECT

public:
  QtObservedMoleculeObserver(QtObservedInstanceBoard *_board, QWidget * _parent = NULL);

signals:
  void FormulaChanged(const QtObservedMolecule::ptr _atom);
  void NameChanged(const QtObservedMolecule::ptr _atom);

  // relayed signals
  void MoleculeInserted(const QtObservedMolecule::ptr _atom);
  void MoleculeRemoved(const atomId_t _atomid);

private slots:
  // relayed, and modified signals
  void formulaChanged();
  void nameChanged();

};

#endif /* QTOBSERVEDMOLECULEOBSERVER_HPP_ */
