/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2016 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * QtObservedMoleculeObserver.cpp
 *
 *  Created on: Mar 17, 2016
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "QtObservedMoleculeObserver.hpp"
#include "UIElements/Qt4/InstanceBoard/QtObservedInstanceBoard.hpp"

#include "CodePatterns/MemDebug.hpp"

QtObservedMoleculeObserver::QtObservedMoleculeObserver(
    QtObservedInstanceBoard *_board,
    QWidget * _parent) :
    QWidget(_parent)
{
    connect(_board, SIGNAL(moleculeInserted(QtObservedMolecule::ptr)),
        this, SIGNAL(MoleculeInserted(QtObservedMolecule::ptr)));
    connect(_board, SIGNAL(moleculeRemoved(const moleculeId_t)),
        this, SIGNAL(MoleculeRemoved(const moleculeId_t)));
}

void QtObservedMoleculeObserver::formulaChanged()
{
  QtObservedMolecule * const walker = static_cast<QtObservedMolecule *>(sender());
  emit FormulaChanged(walker->getRef());
}

void QtObservedMoleculeObserver::nameChanged()
{
  QtObservedMolecule * const walker = static_cast<QtObservedMolecule *>(sender());
  emit NameChanged(walker->getRef());
}
