/*
 * errorLogger.cpp
 *
 *  Created on: Oct 19, 2009
 *      Author: metzler
 */

#include <fstream>
#include "errorlogger.hpp"
#include "verbose.hpp"

ofstream null("/dev/null");

errorLogger* errorLogger::instance = NULL;
int errorLogger::verbosity = 2;
ostream* errorLogger::nix = &null;

/**
 * Constructor. Do not use this function. Use getInstance() instead.
 *
 * \return errorLogger instance
 */
errorLogger::errorLogger()
{
  instance = NULL;
  verbosity = 2;
};

/**
 * Destructor. Better use purgeInstance().
 */
errorLogger::~errorLogger() {
  verbosity = 2;
}

/**
 * Returns the singleton errorLogger instance.
 *
 * \return errorLogger instance
 */
errorLogger* errorLogger::getInstance() {
  if (instance == NULL) {
    instance = new errorLogger();
  }

  return instance;
}


/**
 * Purges the current errorLogger instance.
 */
void errorLogger::purgeInstance() {
  if (instance != NULL) {
    delete instance;
  }

  instance = NULL;
}

/**
 * Sets the verbosity.
 *
 * \param verbosityLevel verbosity
 */
void errorLogger::setVerbosity(int verbosityLevel) {
  verbosity = verbosityLevel;
}

/**
 * Operator for the Binary(arg) call.
 * Constructs temporary a Verbose class object, wherein the Binary is stored.
 * Then << is called, which calls Binary's print which adds the tabs and logs
 * the stream.
 * \param &ost stream to extend
 * \param &m pointer to created Binary object
 * \return &ost
 */
ostream& operator<<(class errorLogger& l, const Verbose& v)
{
  int verbosityLevel = l.verbosity;
  l.nix->clear();
  if (v.DoErrorOutput(verbosityLevel)) {
    switch(v.Verbosity) {
      case 0:
        cerr << "CRITICAL: ";
        break;
      case 1:
        cerr << "ERROR: ";
        break;
      case 2:
        cerr << "WARNING: ";
        break;
      default:
        break;
    }
    v.print(cerr);
    return cerr;
  } else
    return *l.nix;
};
ostream& operator<<(class errorLogger* l, const Verbose& v)
{
  int verbosityLevel = l->verbosity;
  l->nix->clear();
  if (v.DoErrorOutput(verbosityLevel)) {
    switch(v.Verbosity) {
      case 0:
        cerr << "CRITICAL: ";
        break;
      case 1:
        cerr << "ERROR: ";
        break;
      case 2:
      default:
        cerr << "WARNING: ";
        break;
    }
    v.print(cerr);
    return cerr;
  } else
    return *l->nix;
};


