/*
 * GLMoleculeScene.hpp
 *
 *  This is based on the Qt3D example "teaservice", specifically sceneobject.h.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULESCENE_HPP_
#define GLMOLECULESCENE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtCore/qobject.h>
#include <Qt3D/qglpainter.h>

class molecule;
class QGLView;
class GLMoleculeObject_atom;
class GLMoleculeObject_bond;

/** This class represent a single molecule within the scene with all its atoms
 *  and bonds.
 *
 */
class GLMoleculeScene : public QObject
{
   Q_OBJECT
public:
   explicit GLMoleculeScene(QObject *parent, molecule *_mol);
   virtual ~GLMoleculeScene();

   virtual void initialize(QGLView *view, QGLPainter *painter);
   virtual void draw(QGLPainter *painter);

private:
   typedef std::map< size_t, GLMoleculeObject_atom* > AtomNodeMap;
   typedef std::map< std::pair< size_t, size_t> , GLMoleculeObject_bond* > BondNodeMap;
   AtomNodeMap AtomsinMoleculeMap;
   BondNodeMap BondsinMoleculeMap;

   molecule *mol;
};



#endif /* GLMOLECULESCENE_HPP_ */
