/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * GLMoleculeScene.cpp
 *
 *  This is based on the Qt3D example "teaservice", specifically sceneobject.cpp.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeScene.hpp"

#include "GLMoleculeObject.hpp"
#include "GLMoleculeObject_atom.hpp"
#include "GLMoleculeObject_bond.hpp"

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "Bond/bond.hpp"
#include "molecule.hpp"


GLMoleculeScene::GLMoleculeScene(QObject *parent, molecule *_mol) :
   QObject(parent), mol(_mol)
{
  for (molecule::const_iterator atomiter = mol->begin();
      atomiter != mol->end();
      ++atomiter) {
    // create atom objects in scene
    GLMoleculeObject_atom *atomObject= new GLMoleculeObject_atom(this, *atomiter);
    AtomsinMoleculeMap.insert( make_pair((*atomiter)->getId(), atomObject) );

    // create its bonds
    const BondList &bonds = (*atomiter)->getListOfBonds();
    for (BondList::const_iterator bonditer = bonds.begin();
        bonditer != bonds.end();
        ++bonditer) {
      if ((*bonditer)->leftatom->getId() == (*atomiter)->getId()) {
        // create bond objects in scene
        const double distance =
            (*bonditer)->leftatom->getPosition().distance((*bonditer)->rightatom->getPosition())/2.;
        GLMoleculeObject_bond *bondObject= new GLMoleculeObject_bond(this, *bonditer, distance, GLMoleculeObject_bond::left);
        BondsinMoleculeMap.insert( make_pair(
            make_pair(
                (*bonditer)->leftatom->getId(),
                (*bonditer)->rightatom->getId()
                ),
            bondObject) );
        bondObject= new GLMoleculeObject_bond(this, *bonditer, distance, GLMoleculeObject_bond::right);
        BondsinMoleculeMap.insert( make_pair(
            make_pair(
                (*bonditer)->rightatom->getId(),
                (*bonditer)->leftatom->getId()
                ),
            bondObject) );
      }
    }
  }
}

GLMoleculeScene::~GLMoleculeScene()
{
  // remove all elements
  GLMoleculeObject::cleanMaterialMap();
}

void GLMoleculeScene::initialize(QGLView *view, QGLPainter *painter)
{
  // Initialize all of the mesh objects that we have as children.
   foreach (QObject *obj, children()) {
     GLMoleculeObject *meshobj = qobject_cast<GLMoleculeObject *>(obj);
       if (meshobj)
           meshobj->initialize(view, painter);
   }
}

void GLMoleculeScene::draw(QGLPainter *painter)
{
   // Draw all of the mesh objects that we have as children.
   foreach (QObject *obj, children()) {
     GLMoleculeObject *meshobj = qobject_cast<GLMoleculeObject *>(obj);
       if (meshobj)
           meshobj->draw(painter);
   }
}

