/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * GLWorldScene.cpp
 *
 *  This is based on the Qt3D example "teaservice", specifically parts of teaservice.cpp.
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLWorldScene.hpp"

#include "GLMoleculeScene.hpp"
#include "GLMoleculeObject.hpp"

#include "CodePatterns/MemDebug.hpp"

#include "atom.hpp"
#include "molecule.hpp"
#include "World.hpp"


GLWorldScene::GLWorldScene(QObject *parent)
   : QObject(parent)
{
  init();

  //changeMaterials(false);
}

GLWorldScene::~GLWorldScene()
{}

/** Initialise the WorldScene with molecules and atoms from World.
 *
 */
void GLWorldScene::init()
{
  const std::vector<molecule*> &molecules = World::getInstance().getAllMolecules();

  if (molecules.size() > 0) {
    for (std::vector<molecule*>::const_iterator Runner = molecules.begin();
        Runner != molecules.end();
        Runner++) {
      // create molecule
      GLMoleculeScene * const molObject = new GLMoleculeScene(this, *Runner);
      MoleculeSceneList.push_back(molObject);
    }
  }
}

void GLWorldScene::initialize(QGLView *view, QGLPainter *painter) const
{
  for (List_MoleculeScene::const_iterator iter = MoleculeSceneList.begin();
      iter != MoleculeSceneList.end();
      ++iter) {
    (*iter)->initialize(view, painter);
  }
}


void GLWorldScene::draw(QGLPainter *painter) const
{
  for (List_MoleculeScene::const_iterator iter = MoleculeSceneList.begin();
      iter != MoleculeSceneList.end();
      ++iter) {
    (*iter)->draw(painter);
  }
}
//
///** create an atom object in the scene.
// * \param molObject Object of the molecule in the scene to set as parent
// * \param _atom ref to the atom to create
// */
//void GLWorldScene::makeAtom(GLMoleculeObject *&molObject, const atom *&_atom)
//{
//  // create object (hand over getMaterial as callback function)
//  GLMoleculeObject_atom *newatom = new GLMoleculeObject_atom(molObject, _atom, &getMaterial);
//
//  // connect signal
//  connect(newatom, SIGNAL(hoverChanged()), this, SIGNAL(changed()));
//
//  // add to nodes map
//  AtomsinSceneMap.insert( make_pair(_atom->getId(), newatom) );
//}
//
///** Create a bond object in the scene.
// * \param molObject Object of the molecule in the scene to set as parent
// * \param _bond ref to the bond to create
// */
//void GLWorldScene::makeCylinder(GLMoleculeObject *&molObject, const bond *_bond)
//    //const Vector &x, const Vector &y, double radius, double height, const size_t elementno)
//{
//  // create object
//  QGLMoleculeObject_bond *newbond = new QGLMoleculeObject_bond(molObject, _bond, &getMaterial)
//
//  // nothing to connect here
//
//  // add to nodes map
//  BondsinSceneMap.insert(
//      make_pair(
//          make_pair(
//              _bond->leftatom->getId(),
//              _bond->rightatom->getId()
//              ),
//      newatom) );
//}
//
//
//
//QGLSceneNode* GLMoleculeView::getAtom(size_t no)
//{
//  // first some sensibility checks
//  ASSERT(World::getInstance().getAtom(AtomById(no)) != NULL,
//      "GLMoleculeView::getAtom() - desired atom "
//      +toString(no)+" not present in the World.");
//  ASSERT(AtomsinSceneMap.find(no) != AtomsinSceneMap.end(),
//      "GLMoleculeView::getAtom() - desired atom "
//      +toString(no)+" not present in the AtomsinSceneMap.");
//
//  return AtomsinSceneMap[no];
//}
//
//QGLSceneNode* GLMoleculeView::getBond(size_t leftno, size_t rightno)
//{
//  // first some sensibility checks
//  ASSERT(World::getInstance().getAtom(AtomById(leftno)) != NULL,
//      "GLMoleculeView::getAtom() - desired atom "
//      +toString(leftno)+" of bond not present in the World.");
//  ASSERT(World::getInstance().getAtom(AtomById(rightno)) != NULL,
//      "GLMoleculeView::getAtom() - desired atom "
//      +toString(rightno)+" of bond not present in the World.");
//  ASSERT(AtomsinSceneMap.find(leftno) != AtomsinSceneMap.end(),
//      "GLMoleculeView::getAtom() - desired atom "
//      +toString(leftno)+" of bond not present in the AtomsinSceneMap.");
//  ASSERT(AtomsinSceneMap.find(rightno) != AtomsinSceneMap.end(),
//      "GLMoleculeView::getAtom() - desired atom "
//      +toString(rightno)+" of bond not present in the AtomsinSceneMap.");
//  ASSERT(leftno == rightno,
//      "GLMoleculeView::getAtom() - bond must not be between the same atom: "
//      +toString(leftno)+" == "+toString(rightno)+".");
//
//  // then return with smaller index first
//  if (leftno > rightno)
//    return AtomsinSceneMap[ make_pair(rightno, leftno) ];
//  else
//    return AtomsinSceneMap[ make_pair(leftno, rightno) ];
//}

void GLWorldScene::atomClicked()
{
   qDebug("atom clicked");
}
