/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * GLMoleculeObject_atom.cpp
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject_atom.hpp"

#include <Qt3D/qglbuilder.h>
#include <Qt3D/qglscenenode.h>
#include <Qt3D/qglsphere.h>

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Assert.hpp"

#include "atom.hpp"
#include "element.hpp"
#include "LinearAlgebra/Vector.hpp"


static QGLSceneNode * createAtom(QObject *parent)
{
  QGLBuilder builder;
  builder << QGLSphere(0.5);
  QGLSceneNode *n = builder.finalizedSceneNode();
  n->setParent(parent);
  return n;
}

GLMoleculeObject_atom::GLMoleculeObject_atom(QObject *parent, const atom *_atom) :
  GLMoleculeObject(createAtom(parent), parent)
{
  const Vector Position = _atom->getPosition();
  const size_t elementno = _atom->getType()->getNumber();

  // set materials
  QGLMaterial *elementmaterial = getMaterial(elementno);
  ASSERT(elementmaterial != NULL,
      "GLMoleculeObject_atom::GLMoleculeObject_atom() - QGLMaterial ref from getter function is NULL.");
  setMaterial(elementmaterial);
  QGLMaterial *hovermaterial = getMaterial(0); // 0 is the hover material
  ASSERT(hovermaterial != NULL,
      "GLMoleculeObject_atom::GLMoleculeObject_atom() - QGLMaterial ref from getter function for hover is NULL.");
  setHoverMaterial(hovermaterial);

  // set position
  setPosition(QVector3D(Position[0], Position[1], Position[2]));

  // set scale
  setScale( _atom->getType()->getVanDerWaalsRadius());

  // set the object's id
  setObjectId(_atom->getId());

  std::cout << "Created sphere at " << Position << " with elementno " << elementno << "." << endl;
}
