#ifndef BOUNDARY_HPP_
#define BOUNDARY_HPP_

class BoundaryPointSet;
class BoundaryLineSet;
class BoundaryTriangleSet;

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// STL headers
#include <map>
#include <set>
#include <deque>

#include <gsl/gsl_poly.h>

#include "molecules.hpp"

#define DistanceNrPair pair < double, atom* >
#define DistanceMap multimap < double, atom* >
#define DistanceTestPair pair < DistanceMap::iterator, bool>

#define Boundaries map <double, DistanceNrPair >
#define BoundariesPair pair<double, DistanceNrPair >
#define BoundariesTestPair pair< Boundaries::iterator, bool>

#define PointMap map < int, class BoundaryPointSet * > 
#define PointPair pair < int, class BoundaryPointSet * > 
#define PointTestPair pair < PointMap::iterator, bool > 

#define LineMap map < int, class BoundaryLineSet * > 
#define LinePair pair < int, class BoundaryLineSet * > 
#define LineTestPair pair < LinePair::iterator, bool > 

#define TriangleMap map < int, class BoundaryTriangleSet * > 
#define TrianglePair pair < int, class BoundaryTriangleSet * > 
#define TriangleTestPair pair < TrianglePair::iterator, bool > 

#define DistanceMultiMap multimap <double, pair < PointMap::iterator, PointMap::iterator> >
#define DistanceMultiMapPair pair <double, pair < PointMap::iterator, PointMap::iterator> >

template <typename T> void SetEndpointsOrdered(T endpoints[2], T endpoint1, T endpoint2)
{
  if (endpoint1->Nr < endpoint2->Nr) {
    endpoints[0] = endpoint1;
    endpoints[1] = endpoint2;
  } else {
    endpoints[0] = endpoint2;
    endpoints[1] = endpoint1;
  }
};

class BoundaryPointSet {
  public:
    BoundaryPointSet();
    BoundaryPointSet(atom *Walker);
    ~BoundaryPointSet();
    
    void AddLine(class BoundaryLineSet *line);
    
    LineMap lines;
    int LinesCount;
    atom *node;
    int Nr;
};

class BoundaryLineSet {
  public:
    BoundaryLineSet();
    BoundaryLineSet(class BoundaryPointSet *Point[2], int number);
    ~BoundaryLineSet();

    void AddTriangle(class BoundaryTriangleSet *triangle);

    class BoundaryPointSet *endpoints[2];
    TriangleMap triangles;
    int TrianglesCount;
    int Nr;
};

class BoundaryTriangleSet {
  public:
    BoundaryTriangleSet();
    BoundaryTriangleSet(class BoundaryLineSet *line[3], int number);
    ~BoundaryTriangleSet();
    
    void GetNormalVector(Vector &NormalVector);
    
    class BoundaryPointSet *endpoints[3];
    class BoundaryLineSet *lines[3];
    int Nr;
};

class Tesselation {
  public:
    
    Tesselation();
    ~Tesselation();
    
    void TesselateOnBoundary(ofstream *out, config *configuration, molecule *mol);
    void GuessStartingTriangle(ofstream *out);
    void AddPoint(atom * Walker);
    
    PointMap PointsOnBoundary;
    LineMap LinesOnBoundary;
    TriangleMap TrianglesOnBoundary;
    class BoundaryPointSet *BPS[2];
    class BoundaryLineSet *BLS[3];
    class BoundaryTriangleSet *BTS;
    int PointsOnBoundaryCount;
    int LinesOnBoundaryCount;
    int TrianglesOnBoundaryCount;
};


ostream & operator << (ostream &ost, BoundaryPointSet &a);
ostream & operator << (ostream &ost, BoundaryLineSet &a);
ostream & operator << (ostream &ost, BoundaryTriangleSet &a);


double VolumeOfConvexEnvelope(ofstream *out, config *configuration, Boundaries *BoundaryPoints, molecule *mol);
double * GetDiametersOfCluster(ofstream *out, Boundaries *BoundaryPtr, molecule *mol, bool IsAngstroem);
void PrepareClustersinWater(ofstream *out, config *configuration, molecule *mol, double ClusterVolume, double celldensity);


#endif /*BOUNDARY_HPP_*/
