/*
 * TxMenu.h
 *
 *  Created on: Dec 10, 2009
 *      Author: crueger
 */

#ifndef TXMENU_H_
#define TXMENU_H_

#include <list>
#include <iosfwd>
#include <string>

#include "Menu/Menu.hpp"
#include "Actions/Action.hpp"
#include "Actions/ActionTraits.hpp"
#include "defs.hpp"

class MenuItem;

/** Menu for the TextUI.
 *
 * Used to produce any kind of text menu. This is a generic text menu user
 * interface, i.e. we have a list of MenuItem's, which can either be
 * -# Action's
 * -# Displayers
 * -# Separators
 * -# other Menu's
 *
 * In this manner we have a tree structure, the (sub)menus generating new
 * branches, the rest making up the leaves.
 *
 * All Items are displayed via a given output stream and user is prompted
 * for a key. The item corresponding to that key is then activated.
 */
class TxMenu
{
public:
  /** This specific action is used to leave a submenu and return to an upper one.
   * It differs from other Action's (and thus cannot be put into the usual
   * structure) that we have to store the reference to the menu it belongs to.
   * There, we call the doQuit() member function on performCall().
   */
  class LeaveAction : public Action {
  public:
    LeaveAction(TxMenu* const, const ActionTraits &_trait);
    virtual ~LeaveAction();

    bool canUndo();
    bool shouldUndo();

  protected:
    virtual Dialog* fillDialog(Dialog *dialog);
  private:
    virtual void getParametersfromValueStorage();
    virtual Action::state_ptr performCall();
    virtual Action::state_ptr performUndo(Action::state_ptr);
    virtual Action::state_ptr performRedo(Action::state_ptr);

    TxMenu* const menu;
  };

  TxMenu(std::ostream& _outputter, const std::string _title, char _spacer=STD_MENU_TITLE_SPACER,int _length=STD_MENU_LENGTH);
  virtual ~TxMenu();

  void addItem(MenuItem*);
  void removeItem(MenuItem*);
  void display();
  std::string getTitle();
  std::ostream& getOutputter();
  char getSuitableShortForm(std::set <char> &ShortcutList, const std::string name) const;

  /**
   * Call doQuit if you want to return from this menu.
   */
  void doQuit();
  /**
   * Check whether someone has chosen to quit
   */
  bool hasQuit();

  void addDefault(MenuItem*);

protected:
  void showEntry(MenuItem*);

private:
  std::list<MenuItem*> items;

  MenuItem* defaultItem;

  std::ostream& outputter;
  std::string title;
  char spacer;
  int length;

  bool quit;
};

#endif /* TXMENU_H_ */
