/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2015 Frederik Heber. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ObservedValueUnitTest.cpp
 *
 *  Created on: Jun 19, 2015
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ObservedValueUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <boost/bind.hpp>

#include "CodePatterns/ObservedValue.hpp"

#include "stubs/ObservedValue_threeNumbers.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ObservedValueTest );

void ObservedValueTest::setUp(){
  numbers = new ObservedValue_threeNumbers(1,2,3);
  Observable::channels_t ychannel(1, ObservedValue_threeNumbers::YChanged);
  YChange_numbers = new ObservedValue_threeNumbers(1,2,3, ychannel);
}

void ObservedValueTest::tearDown(){
  delete numbers;
  delete YChange_numbers;
}

void ObservedValueTest::doesRecalcTest()
{
  CPPUNIT_ASSERT_EQUAL( 6, (numbers->sum).get());
  CPPUNIT_ASSERT_EQUAL( false, numbers->hasRecalced);
  numbers->hasRecalced=false;
  numbers->setX(4);
  CPPUNIT_ASSERT_EQUAL( true, numbers->hasRecalced);
  CPPUNIT_ASSERT_EQUAL( 9, (numbers->sum).get());
  CPPUNIT_ASSERT_EQUAL( true, numbers->hasRecalced);

  CPPUNIT_ASSERT_EQUAL( 6, (YChange_numbers->sum).get());
  CPPUNIT_ASSERT_EQUAL( false, YChange_numbers->hasRecalced);
  YChange_numbers->hasRecalced=false;
  YChange_numbers->setX(4);
  CPPUNIT_ASSERT_EQUAL( false, YChange_numbers->hasRecalced);
  CPPUNIT_ASSERT_EQUAL( 6, (YChange_numbers->sum).get());
  YChange_numbers->hasRecalced=false;
  YChange_numbers->setY(4);
  CPPUNIT_ASSERT_EQUAL( true, YChange_numbers->hasRecalced);
  CPPUNIT_ASSERT_EQUAL( 11, (YChange_numbers->sum).get());

  numbers->hasRecalced=false;
  numbers->sum.forceUpdate();
  CPPUNIT_ASSERT_EQUAL( true, numbers->hasRecalced);
}
