/*
 * Validator.hpp
 *
 *  Created on: Apr 13, 2012
 *      Author: ankele
 */

#ifndef VALIDATOR_HPP_
#define VALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Clone.hpp"

/** Interface definition for general validator class.
 *
 */
template <class T>
class Validator: public Clone<Validator<T> >
{
public:
  virtual ~Validator() {};

  virtual bool isValid(const T & _value) const=0;
  bool operator()(const T &_value) const {  return isValid(_value);  }

  // comparator
  virtual bool operator==(const Validator<T> &_instance) const=0;
  bool operator!=(const Validator<T> &_instance) const
      { return !((*this)==(_instance)); }
};


#endif /* VALIDATOR_HPP_ */
