/*
 * RangeValidator.hpp
 *
 *  Created on: Apr 13, 2012
 *      Author: ankele
 */

#ifndef RANGEVALIDATOR_HPP_
#define RANGEVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Validator.hpp"
#include "CodePatterns/Range.hpp"

/** A validator with an interval of valid values.
 *
 */
template <class T>
class RangeValidator : public Validator<T>
{
public:
  RangeValidator(const range<T> &_ValidRange) : ValidRange(_ValidRange) {};
  virtual ~RangeValidator() {};

  bool isValid(const T & _value) const
  {
    bool isBefore = true;
    bool isBeyond = true;
    // check left boundary
    isBefore = ValidRange.isBefore(_value);
  //  if (isBefore)
  //    LOG(0, "INFO: " << _value << " is before " << ValidRange.first << ".");
    // check right boundary
    isBeyond = ValidRange.isBeyond(_value) && (_value != ValidRange.last);
  //  if (isBeyond)
  //    LOG(0, "INFO: " << _value << " is beyond " << ValidRange.last << ".");
    return (!isBefore) && (!isBeyond);
  }

  Validator<T>* clone() const { return new RangeValidator<T>(ValidRange); };

  // comparator
  bool operator==(const Validator<T> &_instance) const
  {
    const RangeValidator<T> *inst = dynamic_cast<const RangeValidator<T> *>(&_instance);
    if (inst)
      return ValidRange == inst->ValidRange;
    return false;
  };

private:
  //!> valid range of values
  range<T> ValidRange;
};



#endif /* RANGEVALIDATOR_HPP_ */
