/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the COPYING file or "Copyright notice" in builder.cpp for details.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>. 
 */

/*
 * parseKeySetFile.cpp
 *
 *  Created on: Sep 28, 2012
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "parseKeySetFile.hpp"

#include <sstream>
#include <string>

#include "CodePatterns/Assert.hpp"

#include "Fragmentation/KeySetsContainer.hpp"
#include "Helpers/defs.hpp"


void parseKeySetFile(
    KeySetsContainer &KeySet,
    const std::string &KeySetFilename,
    const size_t FragmentCounter,
    const enum KeySetFileType keysettype
    )
{
  std::stringstream filename;
  switch (keysettype) {
    case NonHydrogenKeySets:
      filename << FRAGMENTPREFIX << KEYSETFILE;
      break;
    case HydrogenKeySets:
      filename << FRAGMENTPREFIX << FORCESFILE;
      break;
    default:
      ASSERT(0, "parseKeySetFile() - unknown KeySetType.");
  }

#ifndef NDEBUG
    bool status =
#endif
      KeySet.ParseKeySets(KeySetFilename, filename.str(), FragmentCounter);
  ASSERT( status,
      "FragmentationResults::FragmentationResults() - ParseKeySets() of "
      +toString(KEYSETFILE)+" failed.");
}
