/*
 * Operation.hpp
 *
 *  Created on: Mar 04, 2012
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_OPERATION_HPP_
#define FRAGMENTCONTROLLER_OPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "JobMarket/Connection.hpp"


/** Class Operation defines the general interface common all Operations
 * whether synchronous or asynchronous. This allows for their storage in
 * a registry.
 *
 */
class Operation
{
public:
  /** Constructor for class Operation.
   *
   * @param _connection connection to use for connect and disconnect
   * @param _name internal name to allow storage in a registry
   */
  Operation(const std::string &_name, Connection &_connection) :
    connection_(_connection),
    status(not_started),
    name(_name)
  {}
  virtual ~Operation()
  {}

  /** Central virtual function that each class deriving from Operation has to implement.
   *
   * Here, connect, some read/writes, and disconnect should occur.
   *
   * @param _host host address to connect to
   * @param _service service to connect to
   */
  virtual void operator()(const std::string& _host, const std::string& _service) = 0;

 /** Getter for name.
   *
   * @return const reference to Operation::name.
   */
  const std::string &getName() const {
    return name;
  }

  //!> enumeration of status codes of the operation
  enum StatusCodes {
    not_started,
    running,
    error,
    success
  };

  /** Returns the current status of the operation.
   *
   * \return status code
   */
  enum StatusCodes getStatus() const {
    return status;
  }

protected:
  //!> The Connection to the server.
  Connection &connection_;

  //!> current status of the operation
  enum StatusCodes status;

private:
  //!> Name of this AsyncOperation (required for Registry pattern)
  std::string name;
};

#endif /* FRAGMENTCONTROLLER_OPERATION_HPP_ */
