/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FileQtQueryPipe.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/QtDialog.hpp"

#include <iostream>
#include <boost/filesystem.hpp>

#include <Qt/qcombobox.h>
#include <Qt/qlineedit.h>
#include <Qt/qpushbutton.h>


FileQtQueryPipe::FileQtQueryPipe(boost::filesystem::path *_content, QtDialog *_dialog, QLineEdit *_filenameLineEdit, QPushButton *_filedialogButton) :
  content(_content),
  dialog(_dialog),
  filenameLineEdit(_filenameLineEdit),
  filedialogButton(_filedialogButton)
{
  theFileDialog = NULL;
}

FileQtQueryPipe::~FileQtQueryPipe()
{
  if (theFileDialog != NULL)
    delete theFileDialog;
}

void FileQtQueryPipe::update() {
  QStringList ListOfFilenames = theFileDialog->selectedFiles();
  std::cout << "Selected File is " << ListOfFilenames.at(0).toStdString() << std::endl;
  (*content) = ListOfFilenames.at(0).toStdString();
  filenameLineEdit->setText(QString::fromStdString((*content).string()));
  dialog->update();
}

void FileQtQueryPipe::showFileDialog() {
  filedialogButton->setFlat(true);
  if (theFileDialog == NULL) {
    theFileDialog = new QFileDialog(NULL, tr("Open input file"), QString(), tr("ParallelCarParrinello (*.conf);;MassivelyParallelQuantumChemistry (*.mpqc);;ParticleDataBase (*.pdb);;XYZ (*.xyz)"));
    theFileDialog->setAcceptMode(QFileDialog::AcceptOpen);
    theFileDialog->setFileMode(QFileDialog::ExistingFile);
    theFileDialog->setViewMode(QFileDialog::List);
  }
  theFileDialog->exec();

  update();
  filedialogButton->setFlat(false);
}


