/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ElementQtQueryPipe.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/QtDialog.hpp"

#include <Qt/qcombobox.h>

#include "element.hpp"
#include "periodentafel.hpp"
#include "World.hpp"


ElementQtQueryPipe::ElementQtQueryPipe(const element **_content, QtDialog *_dialog, QComboBox *_theBox) :
  content(_content),
  dialog(_dialog),
  theBox(_theBox)
{}

ElementQtQueryPipe::~ElementQtQueryPipe()
{}

void ElementQtQueryPipe::update(int newIndex) {
  QVariant data = theBox->itemData(newIndex);
  int idx = data.toInt();
  *content = World::getInstance().getPeriode()->FindElement(idx);
  dialog->update();
}

