/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BoxQtQueryPipe.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/QtDialog.hpp"

#include <Qt/qcombobox.h>
#include <Qt/qtablewidget.h>

#include "LinearAlgebra/Matrix.hpp"
#include "Box.hpp"

BoxQtQueryPipe::BoxQtQueryPipe(Box &_content, QtDialog *_dialog, QTableWidget *_inputTable) :
  content(_content),
  dialog(_dialog),
  inputTable(_inputTable)
{
  tmpM = new Matrix();
  tmpM->zero();
}

BoxQtQueryPipe::~BoxQtQueryPipe()
{
  delete tmpM;
}

void BoxQtQueryPipe::update(int row, int column)
{
  tmpM->at(row, column) = inputTable->item(row, column)->text().toDouble();
  content.setM(*tmpM);
  dialog->update();
}


