/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * AtomsQtQueryPipe.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "UIElements/Qt4/QtDialog.hpp"

#include <vector>

#include <Qt/qlistwidget.h>

#include "Descriptors/AtomIdDescriptor.hpp"
#include "Helpers/MemDebug.hpp"
#include "World.hpp"


AtomsQtQueryPipe::AtomsQtQueryPipe(std::vector<atom *>*_content, QtDialog *_dialog, QListWidget *_theList) :
  content(_content),
  dialog(_dialog),
  theList(_theList)
{}

AtomsQtQueryPipe::~AtomsQtQueryPipe()
{}

void AtomsQtQueryPipe::update() {
  // clear target and put all atoms therein
  (*content).clear();
  for (std::set<atom *>::iterator iter = currentList.begin(); iter != currentList.end(); ++iter)
    (*content).push_back(*iter);
  dialog->update();
}

void AtomsQtQueryPipe::add() {
  QList<QListWidgetItem *> items = theList->selectedItems();
  for (QList<QListWidgetItem *>::iterator iter = items.begin();iter != items.end();++iter) {
    const int index = (*iter)->text().toInt();
    atom *Walker = World::getInstance().getAtom(AtomById(index));
    if (Walker) {
      (*content).push_back(Walker);
      currentList.insert(Walker);
      if (lookup.find(index) != lookup.end())
        lookup.insert(pair<int, atom*>(index, Walker));
    }
  }
  update();
}

void AtomsQtQueryPipe::remove() {
  QList<QListWidgetItem *> items = theList->selectedItems();
  for (QList<QListWidgetItem *>::iterator iter = items.begin();iter != items.end();++iter) {
    const int index = (*iter)->text().toInt();
    atom *Walker = World::getInstance().getAtom(AtomById(index));
    if (Walker) {
      currentList.erase(Walker);
    }
  }
  update();
}


