/*
 * ActionRegistry.cpp
 *
 *  Created on: Jan 7, 2010
 *      Author: crueger
 */

#include "Actions/ActionRegistry.hpp"
#include "Actions/Action.hpp"

#include "Patterns/Singleton_impl.hpp"

#include <string>
#include "Helpers/Assert.hpp"
#include <iostream>

using namespace std;

ActionRegistry::ActionRegistry()
{
}

ActionRegistry::~ActionRegistry()
{
  map<const string,Action*>::iterator iter;
  for(iter=actionMap.begin();iter!=actionMap.end();++iter) {
    delete iter->second;
  }
  actionMap.clear();
}

Action* ActionRegistry::getActionByName(const std::string name){
  map<const string,Action*>::iterator iter;
  iter = actionMap.find(name);
  ASSERT(iter!=actionMap.end(),"Query for an action not stored in registry");
  return iter->second;
}

void ActionRegistry::registerAction(Action* action){
  pair<map<const string,Action*>::iterator,bool> ret;
  ret = actionMap.insert(pair<const string,Action*>(action->getName(),action));
  ASSERT(ret.second,"Two actions with the same name added to registry");
}

CONSTRUCT_SINGLETON(ActionRegistry)
