/*
 * Assert.cpp
 *
 *  Created on: Mar 18, 2010
 *      Author: crueger
 */

#include "Helpers/Assert.hpp"
#include <iostream>

using namespace std;

bool _my_assert::always_throw = false;

bool _my_assert::check(const bool res,
                       const char* condition,
                       const char* message,
                       const char* filename,
                       const int line,
                       bool& ignore)
{
  if(!res){
    cout << "Assertion \"" << condition << "\" failed in file " << filename << " at line " << line << endl;
    cout << "Assertion Message: " << message << std::endl;
    if(always_throw){
      throw AssertException(filename,line);
    }
    while(true){
      cout << "Please choose: (a)bbort, (t)hrow execption, (i)gnore, al(w)ays ignore" << endl;
      char choice;
      cin >> choice;
      switch(choice){
        case 'a':
          return true;
          break;
        case 't':
          throw AssertException(filename,line);
          break;
        case 'w':
          ignore = true;
          // fallthrough
        case 'i':
          return false;
          break;
      }
    }
  }
  return false;
}
