/*
 * RandomNumberValidators.hpp
 *
 *  Created on: May 10, 2012
 *      Author: heber
 */

#ifndef RANDOMNUMBERVALIDATORS_HPP_
#define RANDOMNUMBERVALIDATORS_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "Parameters/Validators/Validator.hpp"

/** This validator checks whether the given string contains the name of a
 * present \ref RandomNumberDistribution.
 */
class RandomNumberDistributionNameValidator : public Validator<std::string>
{
  bool isValid(const std::string & _value) const;
  bool operator==(const Validator<std::string> &_instance) const;
  Validator< std::string >* clone() const;
};

/** This validator checks whether the given string contains the name of a
 * present \ref RandomNumberEngine.
 */
class RandomNumberEngineNameValidator : public Validator<std::string>
{
  bool isValid(const std::string & _value) const;
  bool operator==(const Validator<std::string> &_instance) const;
  Validator< std::string >* clone() const;
};

#endif /* RANDOMNUMBERVALIDATORs_HPP_ */
