/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RandomNumberValidators.cpp
 *
 *  Created on: May 14, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "RandomNumberValidators.hpp"

#include "RandomNumbers/RandomNumberDistributionFactory.hpp"

bool RandomNumberDistributionNameValidator::isValid(const std::string & _value) const
{
  RandomNumberDistributionFactory::getInstance();
  for (RandomNumberDistributionFactory::NameMap::const_iterator
      iter = RandomNumberDistributionFactory::getInstance().names.begin();
      iter != RandomNumberDistributionFactory::getInstance().names.end();
      ++iter) {
    if (_value == iter->second)
      return true;
  }
  return false;
}

bool RandomNumberDistributionNameValidator::operator==(const Validator<std::string> &_instance) const
{
  const RandomNumberDistributionNameValidator *inst =
      dynamic_cast<const RandomNumberDistributionNameValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* RandomNumberDistributionNameValidator::clone() const
{
  Validator< std::string > *inst =
      new RandomNumberDistributionNameValidator();
  return inst;
}









bool RandomNumberEngineNameValidator::isValid(const std::string & _value) const
{
  return true;
}

bool RandomNumberEngineNameValidator::operator==(const Validator<std::string> &_instance) const
{
  const RandomNumberEngineNameValidator *inst =
      dynamic_cast<const RandomNumberEngineNameValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* RandomNumberEngineNameValidator::clone() const
{
  Validator< std::string > *inst =
      new RandomNumberEngineNameValidator();
  return inst;
}




