/*
 * ListOfBondsUnitTest.hpp
 *
 *  Created on: 18 Oct 2009
 *      Author: user
 */

#ifndef LISTOFBONDSUNITTEST_HPP_
#define LISTOFBONDSUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

class element;
class molecule;
class periodentafel;

/********************************************** Test classes **************************************/

class ListOfBondsTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( ListOfBondsTest) ;
    CPPUNIT_TEST ( SetupTest );
    CPPUNIT_TEST ( AddingBondTest );
    CPPUNIT_TEST ( RemovingBondTest );
    CPPUNIT_TEST ( RemovingBondsTest );
    CPPUNIT_TEST ( RemoveAtomTest );
    CPPUNIT_TEST ( DeleteBondTest );
    CPPUNIT_TEST ( DeleteAtomTest );
    CPPUNIT_TEST ( MultipleTimeStepTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void SetupTest();
      void AddingBondTest();
      void RemovingBondTest();
      void RemovingBondsTest();
      void RemoveAtomTest();
      void DeleteBondTest();
      void DeleteAtomTest();
      void MultipleTimeStepTest();

private:

      molecule *TestMolecule;
      const element *hydrogen;
};


#endif /* LISTOFBONDSUNITTEST_HPP_ */
