/*
 * IndexSetContainerUnitTest.hpp
 *
 *  Created on: Jul 3, 2012
 *      Author: heber
 */

#ifndef INDEXSETCONTAINERUNITTEST_HPP_
#define INDEXSETCONTAINERUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include <vector>

#include "Fragmentation/Summation/IndexSet.hpp"
#include "Fragmentation/Summation/IndexSetContainer.hpp"

/********************************************** Test classes **************************************/

class IndexSetContainerTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( IndexSetContainerTest) ;
    CPPUNIT_TEST ( constructorTest );
    CPPUNIT_TEST ( comparatorTest );
    CPPUNIT_TEST ( insertTest );
    CPPUNIT_TEST ( KeySetContainerTest );
    CPPUNIT_TEST ( countSetsTillLevelTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void constructorTest();
      void comparatorTest();
      void insertTest();
      void KeySetContainerTest();
      void countSetsTillLevelTest();

private:
      IndexSetContainer *SV;
      std::vector<IndexSet> allsets;
};

#endif /* INDEXSETCONTAINERUNITTEST_HPP_ */
