/*
 * Box.hpp
 *
 *  Created on: Jun 30, 2010
 *      Author: crueger
 */

#ifndef BOX_HPP_
#define BOX_HPP_

class Matrix;
class Vector;

#include <list>
#include "VectorSet.hpp"

class Box
{
public:
  Box();
  Box(const Box&);
  virtual ~Box();

  const Matrix &getM() const;
  const Matrix &getMinv() const;
  void setM(Matrix);

  Box &operator=(const Box&);
  Box &operator=(const Matrix&);

  Vector translateIn(const Vector &point);
  Vector translateOut(const Vector &point);

  Vector WrapPeriodically(const Vector &point);
  VectorSet<std::list<Vector> > explode(Vector &point);

private:
  Matrix *M;    //!< Defines the layout of the box
  Matrix *Minv; //!< Inverse of M to avoid recomputation
};

#endif /* BOX_HPP_ */
