/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * ParserTypeValidator.cpp
 *
 *  Created on: May 14, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "ParserTypeValidator.hpp"

#include "Parser/FormatParserStorage.hpp"

bool ParserTypeValidator::isValid(const std::string & _value) const
{
  return (FormatParserStorage::getInstance().getTypeFromName(_value) != ParserTypes_end);
}

bool ParserTypeValidator::operator==(const Validator<std::string> &_instance) const
{
  const ParserTypeValidator *inst =
      dynamic_cast<const ParserTypeValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* ParserTypeValidator::clone() const
{
  Validator< std::string > *inst =
      new ParserTypeValidator();
  return inst;
}




