/*
 * QDebugStream.hpp
 *
 *  Created on: Jun 19, 2014
 *      Author: heber
 */

#ifndef QDEBUGSTREAM_HPP_
#define QDEBUGSTREAM_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QTextEdit>
#include <QDebug>

#include <ostream>
#include <streambuf>
#include <string>

/** This class connects an output stream, such as std::cout, and a QTextEdit.
 *
 * It works by overriding certain streambuf functions such as xsputn() and
 * overflow().
 *
 * This code is copied from the questions posted here
 * http://stackoverflow.com/questions/10308425/redirect-stdcout-to-a-qtextedit
 * which worked right away.
 */
class QDebugStream : public std::basic_streambuf<char>
{
public:
  QDebugStream(std::ostream &stream, QTextEdit* text_edit) : m_stream(stream)
  {
    log_window = text_edit;
    m_old_buf = stream.rdbuf();
    stream.rdbuf(this);
  }
  ~QDebugStream()
  {
    // output anything that is left
    if (!m_string.empty()) {
      log_window->append(m_string.c_str());
      qDebug() << m_string.c_str();
    }

    m_stream.rdbuf(m_old_buf);
  }

protected:
  virtual int_type overflow(int_type v)
  {
    if (v == '\n') {
      log_window->append(m_string.c_str());
      qDebug() << m_string.c_str();
      m_string.erase(m_string.begin(), m_string.end());
    } else
      m_string += v;

    return v;
  }

  virtual std::streamsize xsputn(const char *p, std::streamsize n)
  {
    m_string.append(p, p + n);

    size_t pos = 0;
    while (pos != std::string::npos) {
      pos = m_string.find('\n');
      if (pos != std::string::npos) {
        std::string tmp(m_string.begin(), m_string.begin() + pos);
        log_window->append(tmp.c_str());
        qDebug() << tmp.c_str();
        m_string.erase(m_string.begin(), m_string.begin() + pos + 1);
      }
    }

  return n;
  }

private:
  std::ostream &m_stream;
  std::streambuf *m_old_buf;
  std::string m_string;

  QTextEdit* log_window;
};

#endif /* QDEBUGSTREAM_HPP_ */
