/*
 * AtomDescriptorTest.hpp
 *
 *  Created on: Feb 9, 2010
 *      Author: crueger
 */

#ifndef ATOMDESCRIPTORTEST_HPP_
#define ATOMDESCRIPTORTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

#include "types.hpp"

// we prefer enum over define
enum { ATOM_COUNT = 10 };

class atom;

class AtomDescriptorTest : public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( AtomDescriptorTest );
  CPPUNIT_TEST ( AtomBaseSetsTest );
  CPPUNIT_TEST ( AtomIdTest );
  CPPUNIT_TEST ( AtomCalcTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void AtomBaseSetsTest();
  void AtomIdTest();
  void AtomCalcTest();

private:
  atom *atoms [ATOM_COUNT];
  atomId_t atomIds [ATOM_COUNT];
};

#endif /* ATOMDESCRIPTORTEST_HPP_ */
