#ifndef BOUNDARY_HPP_
#define BOUNDARY_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <fstream>
#include <iosfwd>

// STL headers
#include <map>

#include "defs.hpp"

/****************************************** forward declarations *****************************/

class atom;
class BoundaryPointSet;
class BoundaryLineSet;
class BoundaryTriangleSet;
class config;
class LinkedCell;
class molecule;
class MoleculeListClass;
class Tesselation;
class Vector;

/********************************************** definitions *********************************/

enum { DEBUG=1 };
enum { DoSingleStepOutput=0 };
enum { SingleStepWidth=10 };

typedef std::pair < double, class atom* > DistancePair;
typedef std::multimap < double, class atom* > DistanceMap;
typedef std::pair < DistanceMap::iterator, bool> DistanceTestPair;

typedef std::map <double, DistancePair > Boundaries;
typedef std::pair<double, DistancePair > BoundariesPair;
typedef std::pair< Boundaries::iterator, bool> BoundariesTestPair;

/********************************************** declarations *******************************/

double ConvexizeNonconvexEnvelope(class Tesselation *&TesselStruct, const molecule * const mol, const char * const filename);
molecule * FillBoxWithMolecule(MoleculeListClass *List, molecule *filler, config &configuration, const double MaxDistance, const double distance[NDIM], const double boundary, const double RandomAtomDisplacement, const double RandomMolDisplacement, const bool DoRandomRotation);
void FindConvexBorder(const molecule* const mol, Boundaries *BoundaryPts, Tesselation *&TesselStruct, const LinkedCell *LCList, const char *filename);
Vector* FindEmbeddingHole(MoleculeListClass *mols, molecule *srcmol);
void FindNextSuitablePoint(class BoundaryTriangleSet *BaseTriangle, class BoundaryLineSet *BaseLine, atom*& OptCandidate, Vector *OptCandidateCenter, double *ShortestAngle, const double RADIUS, LinkedCell *LC);
bool FindNonConvexBorder(const molecule* const mol, Tesselation *&TesselStruct, const LinkedCell *&LC, const double RADIUS, const char *tempbasename);
Boundaries *GetBoundaryPoints(const molecule *mol, Tesselation *&TesselStruct);
double * GetDiametersOfCluster(const Boundaries *BoundaryPtr, const molecule *mol, Tesselation *&TesselStruct, const bool IsAngstroem);
void PrepareClustersinWater(config *configuration, molecule *mol, double ClusterVolume, double celldensity);
bool RemoveAllBoundaryPoints(class Tesselation *&TesselStruct, const molecule * const mol, const char * const filename);
void StoreTrianglesinFile(const molecule * const mol, const Tesselation * const TesselStruct, const char *filename, const char *extraSuffix);
double VolumeOfConvexEnvelope(class Tesselation *TesselStruct, class config *configuration);


#endif /*BOUNDARY_HPP_*/
