/*
 * bondgraph.hpp
 *
 *  Created on: Oct 29, 2009
 *      Author: heber
 */

#ifndef BONDGRAPH_HPP_
#define BONDGRAPH_HPP_

using namespace std;

/*********************************************** includes ***********************************/

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>


/****************************************** forward declarations *****************************/

class molecule;
class BondedParticle;
class MatrixContainer;

/********************************************** definitions *********************************/

/********************************************** declarations *******************************/


class BondGraph {
public:
  BondGraph(bool IsA);
  ~BondGraph();
  bool LoadBondLengthTable(const string &filename);
  bool ConstructBondGraph(molecule * const mol);
  double GetBondLength(int firstelement, int secondelement);
  double SetMaxDistanceToMaxOfCovalentRadii(const molecule * const mol);

  void BondLengthMatrixMinMaxDistance(BondedParticle * const Walker, BondedParticle * const OtherWalker, double &MinDistance, double &MaxDistance, bool IsAngstroem);
  void CovalentMinMaxDistance(BondedParticle * const Walker, BondedParticle * const OtherWalker, double &MinDistance, double &MaxDistance, bool IsAngstroem);

private:
  static const double BondThreshold;

  MatrixContainer *BondLengthMatrix;
  double max_distance;
  bool IsAngstroem;
};

#endif /* BONDGRAPH_HPP_ */
