/*
 * ThermoStatContainer.hpp
 *
 *  Created on: 12.06.2010
 *      Author: heber
 */

#ifndef THERMOSTATCONTAINER_HPP_
#define THERMOSTATCONTAINER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class ConfigFileBuffer;

enum { MaxThermostats=6 };      //!< maximum number of thermostat entries in Ions#ThermostatNames and Ions#ThermostatImplemented
enum thermostats { None, Woodcock, Gaussian, Langevin, Berendsen, NoseHoover };   //!< Thermostat names for output

class ThermoStatContainer {
public:
  ThermoStatContainer();
  ~ThermoStatContainer();

  void ParseThermostats(class ConfigFileBuffer * const fb);

  int Thermostat;
  int *ThermostatImplemented;
  char **ThermostatNames;
  double TempFrequency;
  double alpha;
  double HooverMass;
  double TargetTemp;
  int ScaleTempStep;
};

#endif /* THERMOSTATCONTAINER_HPP_ */
