/*
 * CandidateForTesselation.hpp
 *
 *  Created on: Jul 29, 2010
 *      Author: heber
 */

#ifndef CANDIDATEFORTESSELATION_HPP_
#define CANDIDATEFORTESSELATION_HPP_

#include "BoundaryMaps.hpp"
#include "LinearAlgebra/Vector.hpp"

#include <list>
#include <set>

class BoundaryLineSet;
class BoundaryPointSet;
class BoundaryTriangleSet;
class LinkedCell;
class TesselPoint;

class CandidateForTesselation {
  public :
  CandidateForTesselation(BoundaryLineSet* currentBaseLine);
  CandidateForTesselation(TesselPoint* candidate, BoundaryLineSet* currentBaseLine, BoundaryPointSet *point, const Vector &OptCandidateCenter, const Vector &OtherOptCandidateCenter);
  ~CandidateForTesselation();

  bool CheckValidity(const double RADIUS, const class LinkedCell *LC) const;

  TesselPointList pointlist;
  const BoundaryLineSet * BaseLine;
  const BoundaryPointSet * ThirdPoint;
  const BoundaryTriangleSet *T;
  Vector OldCenter;
  Vector OptCenter;
  Vector OtherOptCenter;
  double ShortestAngle;
  double OtherShortestAngle;

  private:
  static const double HULLEPSILON; //!< TODO: Get rid of HULLEPSILON, points to numerical instabilities
};

std::ostream & operator <<(std::ostream &ost, const  CandidateForTesselation &a);


#endif /* CANDIDATEFORTESSELATION_HPP_ */
