/*
 * BoundaryTriangleSet.hpp
 *
 *  Created on: Jul 29, 2010
 *      Author: heber
 */

#ifndef BOUNDARYTRIANGLESET_HPP_
#define BOUNDARYTRIANGLESET_HPP_

#include "BoundaryMaps.hpp"
#include "LinearAlgebra/Vector.hpp"

class BoundaryLineSet;
class BoundaryPointSet;
class BoundaryTriangleSet;
class Plane;
class TesselPoint;

class BoundaryTriangleSet {
  public:
    BoundaryTriangleSet();
    BoundaryTriangleSet(class BoundaryLineSet * const line[3], const int number);
    ~BoundaryTriangleSet();

    void GetNormalVector(const Vector &NormalVector);
    void GetCenter(Vector &center) const;
    bool GetIntersectionInsideTriangle(const Vector & MolCenter, const Vector &x, Vector &Intersection) const;
    double GetClosestPointInsideTriangle(const Vector &x, Vector &ClosestPoint) const;
    bool ContainsBoundaryLine(const BoundaryLineSet * const line) const;
    bool ContainsBoundaryPoint(const BoundaryPointSet * const point) const;
    bool ContainsBoundaryPoint(const TesselPoint * const point) const;
    class BoundaryPointSet *GetThirdEndpoint(const BoundaryLineSet * const line) const;
    class BoundaryLineSet *GetThirdLine(const BoundaryPointSet * const point) const;
    bool IsPresentTupel(const BoundaryPointSet * const Points[3]) const;
    bool IsPresentTupel(const BoundaryTriangleSet * const T) const;

    Plane getPlane() const;
    Vector getEndpoint(int) const;
    std::string getEndpointName(int) const;

    class BoundaryPointSet *endpoints[3];
    class BoundaryLineSet *lines[3];
    Vector NormalVector;
    Vector SphereCenter;
    int Nr;

  private:

};

std::ostream & operator << (std::ostream &ost, const BoundaryTriangleSet &a);


#endif /* BOUNDARYTRIANGLESET_HPP_ */
