/*
 * BoundaryMaps.hpp
 *
 *  Created on: Jul 29, 2010
 *      Author: heber
 */

#ifndef BOUNDARYMAPS_HPP_
#define BOUNDARYMAPS_HPP_

class BoundaryPointSet;
class BoundaryLineSet;
class BoundaryTriangleSet;
class BoundaryPolygonSet;
class CandidateForTesselation;
class TesselPoint;

#include <list>
#include <map>
#include <set>

typedef std::map <int, int> IndexToIndex;

typedef std::map < int, class BoundaryPointSet * > PointMap;
typedef std::set < class BoundaryPointSet * > PointSet;
typedef std::list < class BoundaryPointSet * > PointList;
typedef std::pair < int, class BoundaryPointSet * > PointPair;
typedef std::pair < PointMap::iterator, bool > PointTestPair;

typedef std::list <class CandidateForTesselation *> CandidateList;
typedef std::map <class BoundaryLineSet *, class CandidateForTesselation *> CandidateMap;

typedef std::multimap < int, class BoundaryLineSet * > LineMap;
typedef std::set < class BoundaryLineSet * > LineSet;
typedef std::list < class BoundaryLineSet * > LineList;
typedef std::pair < int, class BoundaryLineSet * > LinePair;
typedef std::pair < LineMap::iterator, bool > LineTestPair;

typedef std::map < int, class BoundaryTriangleSet * > TriangleMap;
typedef std::set < class BoundaryTriangleSet * > TriangleSet;
typedef std::list < class BoundaryTriangleSet * > TriangleList;
typedef std::pair < int, class BoundaryTriangleSet * > TrianglePair;
typedef std::pair < TriangleMap::iterator, bool > TriangleTestPair;

typedef std::map < int, class BoundaryPolygonSet * > PolygonMap;
typedef std::set < class BoundaryPolygonSet * > PolygonSet;
typedef std::list < class BoundaryPolygonSet * > PolygonList;

typedef std::multimap <double, class BoundaryPointSet * > DistanceToPointMap;
typedef std::pair <double, class BoundaryPointSet * > DistanceToPointPair;

typedef std::multimap <double, std::pair < PointMap::iterator, PointMap::iterator> > DistanceMultiMap;
typedef std::pair <double, std::pair < PointMap::iterator, PointMap::iterator> > DistanceMultiMapPair;

typedef std::list <TesselPoint *> TesselPointList;
typedef std::set <TesselPoint *> TesselPointSet;

typedef std::list<std::list <TesselPoint *> *> ListOfTesselPointList;

enum centers {Opt, OtherOpt};




#endif /* BOUNDARYMAPS_HPP_ */
