/*
 * tesselation_boundarytriangleunittest.cpp
 *
 *  Created on: Jan 13, 2010
 *      Author: heber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cstring>
#include <iostream>

#include "defs.hpp"
#include "TesselPoint.hpp"
#include "BoundaryPointSet.hpp"
#include "BoundaryLineSet.hpp"
#include "BoundaryTriangleSet.hpp"
#include "CandidateForTesselation.hpp"
#include "tesselation_boundarytriangleunittest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

const double TesselationBoundaryTriangleTest::SPHERERADIUS=2.;

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( TesselationBoundaryTriangleTest );


void TesselationBoundaryTriangleTest::setUp()
{
  setVerbosity(5);

  // create nodes
  tesselpoints[0] = new TesselPoint;
  tesselpoints[0]->setPosition(Vector(0., 0., 0.));
  tesselpoints[0]->setName("1");
  tesselpoints[0]->nr = 1;
  points[0] = new BoundaryPointSet(tesselpoints[0]);
  tesselpoints[1] = new TesselPoint;
  tesselpoints[1]->setPosition(Vector(0., 1., 0.));
  tesselpoints[1]->setName("2");
  tesselpoints[1]->nr = 2;
  points[1] = new BoundaryPointSet(tesselpoints[1]);
  tesselpoints[2] = new TesselPoint;
  tesselpoints[2]->setPosition(Vector(1., 0., 0.));
  tesselpoints[2]->setName("3");
  tesselpoints[2]->nr = 3;
  points[2] = new BoundaryPointSet(tesselpoints[2] );

  // create line
  lines[0] = new BoundaryLineSet(points[0], points[1], 0);
  lines[1] = new BoundaryLineSet(points[1], points[2], 1);
  lines[2] = new BoundaryLineSet(points[0], points[2], 2);

  // create triangle
  triangle = new BoundaryTriangleSet(lines, 0);
  triangle->GetNormalVector(Vector(0.,0.,1.));
};


void TesselationBoundaryTriangleTest::tearDown()
{
  delete(triangle);
  for (int i=0;i<3;++i) {
    // TesselPoint does not delete its vector as it only got a reference
    delete tesselpoints[i];
  }
  logger::purgeInstance();
  errorLogger::purgeInstance();
};

/** UnitTest for Tesselation::IsInnerPoint()
 */
void TesselationBoundaryTriangleTest::GetClosestPointOnPlaneTest()
{
  Vector TestIntersection;
  Vector Point;

  // simple test on y line
  Point = Vector(-1.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( 1., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point = Vector(-4.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( 16., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on x line
  Point = Vector(0.5,-1.,0.);
  CPPUNIT_ASSERT_EQUAL( 1., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.5,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point = Vector(0.5,-6.,0.);
  CPPUNIT_ASSERT_EQUAL( 36., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.5,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on slanted line
  Point = Vector(1.,1.,0.);
  CPPUNIT_ASSERT_EQUAL( 0.5, triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.5,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point = Vector(5.,5.,0.);
  CPPUNIT_ASSERT_EQUAL( 40.5, triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.5,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on first node
  Point = Vector(-1.,-1.,0.);
  CPPUNIT_ASSERT_EQUAL( 2., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on second node
  Point = Vector(0.,2.,0.);
  CPPUNIT_ASSERT_EQUAL( 1., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.,1.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on third node
  Point = Vector(2.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( 1., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(1.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
};

/** UnitTest for Tesselation::IsInnerPoint()
 */
void TesselationBoundaryTriangleTest::GetClosestPointOffPlaneTest()
{
  Vector TestIntersection;
  Vector Point;

  // straight down/up
  Point = Vector(1./3.,1./3.,+5.);
  CPPUNIT_ASSERT_EQUAL( 25. , triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(1./3.,1./3.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point = Vector(1./3.,1./3.,-5.);
  CPPUNIT_ASSERT_EQUAL( 25. , triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(1./3.,1./3.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on y line
  Point = Vector(-1.,0.5,+2.);
  CPPUNIT_ASSERT_EQUAL( 5., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point = Vector(-1.,0.5,-3.);
  CPPUNIT_ASSERT_EQUAL( 10., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on x line
  Point = Vector(0.5,-1.,+1.);
  CPPUNIT_ASSERT_EQUAL( 2., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.5,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point = Vector(0.5,-1.,-2.);
  CPPUNIT_ASSERT_EQUAL( 5., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.5,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on slanted line
  Point = Vector(1.,1.,+3.);
  CPPUNIT_ASSERT_EQUAL( 9.5, triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.5,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
  Point = Vector(1.,1.,-4.);
  CPPUNIT_ASSERT_EQUAL( 16.5, triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.5,0.5,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on first node
  Point = Vector(-1.,-1.,5.);
  CPPUNIT_ASSERT_EQUAL( 27., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on second node
  Point = Vector(0.,2.,5.);
  CPPUNIT_ASSERT_EQUAL( 26., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(0.,1.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );

  // simple test on third node
  Point = Vector(2.,0.,5.);
  CPPUNIT_ASSERT_EQUAL( 26., triangle->GetClosestPointInsideTriangle(Point, TestIntersection) );
  Point = Vector(1.,0.,0.);
  CPPUNIT_ASSERT_EQUAL( true , Point == TestIntersection );
};
