/*
 * atomsCalculationTest.hpp
 *
 *  Created on: Feb 19, 2010
 *      Author: crueger
 */

#ifndef ATOMSCALCULATIONTEST_HPP_
#define ATOMSCALCULATIONTEST_HPP_

#include <cppunit/extensions/HelperMacros.h>

// we prefer enum over define
enum { ATOM_COUNT = 10 };

#include "types.hpp"

class atom;

class atomsCalculationTest :  public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( atomsCalculationTest );
  CPPUNIT_TEST ( testCalculateSimple );
  CPPUNIT_TEST ( testCalculateExcluded );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void testCalculateSimple();
  void testCalculateExcluded();

private:
  atom *atoms [ATOM_COUNT];
  atomId_t atomIds [ATOM_COUNT];
};

#endif /* ATOMSCALCULATIONTEST_HPP_ */
