/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * QtToolBar.cpp
 *
 *  Created on: Apr 26, 2012
 *      Author: ankele
 */




// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "QtToolBar.hpp"

#include "CodePatterns/MemDebug.hpp"

QtToolBar::QtToolBar(QWidget * _parent) :
  QToolBar(_parent)
{
  addActionItem("undo", "undo the last Action", "edit-undo");
  addActionItem("redo", "redo the last Action", "edit-redo");
}


QtToolBar::~QtToolBar()
{
}


void QtToolBar::addActionItem(const std::string &token, const std::string &description, const std::string &icon_name)
{
  QAction *action = addAction(QString(description.c_str()));
  action->setIcon(FavActions.getIcon(token, icon_name));
  action->setToolTip(QString(description.c_str()));
  QtMenuPipe *pipe = new QtMenuPipe(token,action);
  QObject::connect(action, SIGNAL(triggered()),pipe,SLOT(called()));
  plumbing.push_back(pipe);
  present_actions.insert( token );
}

void QtToolBar::addFavoriteActionItems(const unsigned int _max)
{
  // separate favorite actions
  addSeparator();
  FavActions.addToolBarActions(*this, _max);
}

