/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2016 Frederik Heber. All rights reserved.
 * Please see the COPYING file or "Copyright notice" in builder.cpp for details.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * RegistrySerializer_Particle.cpp
 *
 *  Created on: Mar 09, 2016
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "RegistrySerializer_impl.hpp"

#include <iostream>
#include <map>

#include "CodePatterns/Assert.hpp"
#include "CodePatterns/Log.hpp"

#include "Potentials/Particles/Particle.hpp"

template <>
void RegistrySerializer<Particle>::operator()()
{
  if (instance.getBeginIter() == instance.getEndIter())
    return;
  // we need to prepend and append with section start and end
  to_serialize << "particles {" << std::endl;
  for (Registry<Particle>::const_iterator iter = instance.getBeginIter();
      iter != instance.getEndIter(); ++iter)
  {
    const Particle * const item = iter->second;
    LOG(1, "INFO: Now serializing " << name << ".");
    item->stream_to(to_serialize);
    to_serialize << std::endl;
  }
  to_serialize << "}" << std::endl;
}
