/*
 * RegistrySerializer.hpp
 *
 *  Created on: 09.05.2013
 *      Author: heber
 */

#ifndef REGISTRYSERIALIZER_HPP_
#define REGISTRYSERIALIZER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>

#include "CodePatterns/Registry.hpp"

class Particle;

/** This template class can serialize items contained in a general Registry
 * that contain function stream_to().
 */
template <class T>
class RegistrySerializer
{
public:
  /** Constructor for class RegistrySerializer.
   *
   * \param _to_serialize stream to serialize to
   * \param _instance registry instance to serialize
   * \param _name optional name for debugging
   */
  RegistrySerializer(
      std::ostream &_to_serialize,
      Registry<T> &_instance,
      const std::string _name = "item") :
    to_serialize(_to_serialize),
    instance(_instance),
    name(_name)
  {}

  /** Destructor for class RegistrySerializer.
   *
   */
  ~RegistrySerializer()
  {}

  /** Function to stream all potentials present in PotentialRegistry to
   * internally stored stream.
   *
   */
  void operator()();

private:
  std::ostream &to_serialize;
  const Registry<T> &instance;
  const std::string name;
};

#include "RegistrySerializer_impl.hpp"

template <>
void RegistrySerializer<Particle>::operator()();

#endif /* REGISTRYSERIALIZER_HPP_ */
