/*
 * PdbAtomInfoContainer.hpp
 *
 *  Created on: Dec 4, 2010
 *      Author: heber
 */

#ifndef PDBATOMINFOCONTAINER_HPP_
#define PDBATOMINFOCONTAINER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include "PdbKey.hpp"

class PdbParser;
class Vector;

#include <string>
#include <typeinfo>

/**
 * Holds tremolo-specific information which is not store in the atom class.
 */
class PdbAtomInfoContainer {
  friend class PdbParser;
public:
  PdbAtomInfoContainer();
  ~PdbAtomInfoContainer();

  // getter and setter
  template <class T> T get(const PdbKey::PdbDataKey key) const  {
    switch (key) {
      default :
        std::cout << "Unknown key or not representable as " << typeid(T).name() << ": " << key << std::endl;
        break;
    }
    return (T)NULL;
  }
  void set(const PdbKey::PdbDataKey key, std::string value);

  /** Scans a value from a short string and checks whether its empty.
   *
   * @param value value to set
   * @param _piece short string
   */
  template <class T> static void ScanKey(T& value, std::string _piece)
  {
    ConvertTo<T> toValue;
    // scan all empty chars ' ' and skip
    std::string::iterator iter = _piece.begin();
    for (;iter != _piece.end();++iter)
      if ((*iter != ' ') && (*iter != '\t'))
        break;
    // only set if there is something contained in the string
    if (iter != _piece.end()) {
      _piece.erase(_piece.begin(), iter);
      value = toValue(_piece);
    }
  }

  const std::string& getDataKey(PdbKey::PdbDataKey key) const;

private:

  static void fillknownDataKeys();
  static void clearknownDataKeys();

  typedef std::map<PdbKey::PdbDataKey, std::string> knownDataKeysMap;
  static knownDataKeysMap knownDataKeys;
  static bool knownDataKeys_Filled;

  std::string token;
  int serial;
  std::string name;
  char altLoc;
  std::string resName;
  char chainID;
  int resSeq;
  char iCode;
  Vector XYZ;
  float occupancy;
  float tempFactor;
  std::string element;
  int charge;
  size_t timestep;
};

std::ostream& operator<<(std::ostream &ost, const PdbAtomInfoContainer& m);

template <>
std::string PdbAtomInfoContainer::get<std::string>(const PdbKey::PdbDataKey key) const;
template <>
int PdbAtomInfoContainer::get<int>(const PdbKey::PdbDataKey key) const;
template <>
double PdbAtomInfoContainer::get<double>(const PdbKey::PdbDataKey key) const;

#endif /* PDBATOMINFOCONTAINER_HPP_ */
