/*
 * ChangeElementAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/AtomAction/ChangeElementAction.hpp"
#include "atom.hpp"
#include "log.hpp"
#include "vector.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/MapOfActions.hpp"

const char AtomChangeElementAction::NAME[] = "change-element";

AtomChangeElementAction::AtomChangeElementAction() :
  Action(NAME)
{}

AtomChangeElementAction::~AtomChangeElementAction()
{}

Action::state_ptr AtomChangeElementAction::performCall() {
  Dialog *dialog = UIFactory::getInstance().makeDialog();
  atom *first = NULL;
  std::vector<element *> elements;

  dialog->queryElement(NAME, &elements, MapOfActions::getInstance().getDescription(NAME));
  dialog->queryAtom("atom-by-id", &first, MapOfActions::getInstance().getDescription("atom-by-id"));

  if(dialog->display()) {
    delete dialog;
    ASSERT(elements.size() == 1, "Unequal to one element specified when changing an atom's element");
    ASSERT(first != NULL, "No valid atom specified");
    DoLog(1) && (Log() << Verbose(1) << "Changing atom " << *first << " to element " << elements.at(0) << "." << endl);
    if (elements.at(0) != NULL) {
      first->type = elements.at(0);
      return Action::success;
    } else
      return Action::failure;
  } else {
    delete dialog;
    return Action::failure;
  }

}

Action::state_ptr AtomChangeElementAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr AtomChangeElementAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool AtomChangeElementAction::canUndo() {
  return false;
}

bool AtomChangeElementAction::shouldUndo() {
  return false;
}

const string AtomChangeElementAction::getName() {
  return NAME;
}
