/*
 * SendJobToWorkerOperation.hpp
 *
 *  Created on: Feb 22, 2012
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_SENDJOBTOWORKEROPERATION_HPP_
#define FRAGMENTCONTROLLER_SENDJOBTOWORKEROPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"

#include "Jobs/FragmentJob.hpp"
#include "Jobs/SystemCommandJob.hpp"
#include "Operations/AsyncOperation.hpp"
#include "WorkerAddress.hpp"

class SendJobToWorkerOperation : public AsyncOperation  {
public:
  /** Constructor for class SendJobToWorkerOperation.
   *
   * @param _connection connection for operation
   */
  SendJobToWorkerOperation(Connection &_connection) :
    AsyncOperation(std::string("sendjobtoworker"),_connection),
    job( new SystemCommandJob(std::string("/bin/true"), std::string("donothing"), JobId::NoJob) )
  {}
  /** Constructor for class SendJobToWorkerOperation.
   *
   * @param _connection connection for operation
   * @param _job job to send to worker
   */
  SendJobToWorkerOperation(Connection &_connection, FragmentJob::ptr &_job) :
    AsyncOperation(std::string("sendjobtoworker"),_connection),
    job( _job )
  {}
  /// Destructor for class SendJobToWorkerOperation
  ~SendJobToWorkerOperation() {}

  /** Setter for job.
   *
   * @param _job job to take over internally
   */
  void setJob(FragmentJob::ptr &_job)
  {
    job.reset();
    job = _job;
  }

public:
  // virtual function pointer to the connection handler
  virtual void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

private:
  //!> job to send to
  FragmentJob::ptr job;
};

#endif /* FRAGMENTCONTROLLER_SENDJOBTOWORKEROPERATION_HPP_ */
