/*
 * ObservedValue_UpdateAtoms.hpp
 *
 *  Created on: Oct 17, 2015
 *      Author: heber
 */


#ifndef OBSERVEDVALUE_UPDATEATOMS_HPP_
#define OBSERVEDVALUE_UPDATEATOMS_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <set>

#include <boost/function.hpp>

#include "ObservedValue_wCallback.hpp"

#include "Descriptors/MoleculeIdDescriptor.hpp"
#include "types.hpp"
#include "World.hpp"

/** This is a specialization of ObservedValue_wCallback for a set of atomic ids.
 *
 * The problem is that on an update signal we only get a single id. However, get()
 * requires us to return a set of ids (namely all contained atoms by id and update
 * only gives left or added ones).
 *
 * Hence, we need to add a member variable storing the current set.
 *
 */
class ObservedValue_UpdateAtoms : public ObservedValue_wCallback< std::set<atomId_t> >
{
  typedef std::set<atomId_t> atoms_t;

public:
  ObservedValue_UpdateAtoms(
    const Observable * const _owner,
    const std::string &_name,
    const Observable::channels_t &_channels,
    const boost::function<void()> &_callback,
    const boost::function<const moleculeId_t ()> &_getMolIndex
    ) :
      ObservedValue_wCallback<atoms_t>(
          _owner,
          boost::bind(&ObservedValue_UpdateAtoms::updateAtoms,
              this), _name,
              atoms_t(),
              _channels,
              _callback),
      getMolIndex(_getMolIndex)
    {}

  virtual ~ObservedValue_UpdateAtoms ()
  {}

protected:
  atoms_t updateAtoms()
  {
    atoms_t current_atomset = get();
    const molecule * const mol = const_cast<const World &>(World::getInstance()).
        getMolecule(MoleculeById(getMolIndex()));
    if (mol != NULL) {
      const atomId_t id = mol->lastChangedAtomId();
      if (mol->containsAtom(id))
        current_atomset.insert(id);
      else
        current_atomset.erase(id);
    }
    return current_atomset;
  }

private:

  //!> contains the set of atoms displayed
  atoms_t DisplayedAtoms;

  //!> getter function for the molecule index whose current set of atoms we observe
  const boost::function<const moleculeId_t ()> getMolIndex;
};

#endif /* OBSERVEDVALUE_UPDATEATOMS_HPP_ */
