/*
 * RotateToPrincipalAxisSystemAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/MoleculeAction/RotateToPrincipalAxisSystemAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "log.hpp"
#include "molecule.hpp"
#include "verbose.hpp"


#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

/****** MoleculeRotateToPrincipalAxisSystemAction *****/

// memento to remember the state when undoing

//class MoleculeRotateToPrincipalAxisSystemState : public ActionState {
//public:
//  MoleculeRotateToPrincipalAxisSystemState(molecule* _mol,std::string _lastName) :
//    mol(_mol),
//    lastName(_lastName)
//  {}
//  molecule* mol;
//  std::string lastName;
//};

const char MoleculeRotateToPrincipalAxisSystemAction::NAME[] = "rotate-to-pas";

MoleculeRotateToPrincipalAxisSystemAction::MoleculeRotateToPrincipalAxisSystemAction() :
  Action(NAME)
{}

MoleculeRotateToPrincipalAxisSystemAction::~MoleculeRotateToPrincipalAxisSystemAction()
{}

void MoleculeRotateToPrincipalAxisSystem() {
  ActionRegistry::getInstance().getActionByName(MoleculeRotateToPrincipalAxisSystemAction::NAME)->call(Action::NonInteractive);
};

Dialog* MoleculeRotateToPrincipalAxisSystemAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryEmpty(NAME, MapOfActions::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr MoleculeRotateToPrincipalAxisSystemAction::performCall() {
  molecule *mol = NULL;

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(0) && (Log() << Verbose(0) << "Converting to prinicipal axis system." << endl);
    mol->PrincipalAxisSystem(true);
  }
  return Action::success;
}

Action::state_ptr MoleculeRotateToPrincipalAxisSystemAction::performUndo(Action::state_ptr _state) {
//  MoleculeRotateToPrincipalAxisSystemState *state = assert_cast<MoleculeRotateToPrincipalAxisSystemState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeRotateToPrincipalAxisSystemAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeRotateToPrincipalAxisSystemAction::canUndo() {
  return false;
}

bool MoleculeRotateToPrincipalAxisSystemAction::shouldUndo() {
  return false;
}

const string MoleculeRotateToPrincipalAxisSystemAction::getName() {
  return NAME;
}
