/*
 * VersionAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/VersionAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "version.h"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

const char CommandLineVersionAction::NAME[] = "version";

CommandLineVersionAction::CommandLineVersionAction() :
  Action(NAME)
{}

CommandLineVersionAction::~CommandLineVersionAction()
{}

void CommandVersion() {
  ActionRegistry::getInstance().getActionByName(CommandLineVersionAction::NAME)->call(Action::NonInteractive);
};

Dialog* CommandLineVersionAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryEmpty(NAME, ESPACKVersion);

  return dialog;
}

Action::state_ptr CommandLineVersionAction::performCall() {
  return Action::success;
}

Action::state_ptr CommandLineVersionAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr CommandLineVersionAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool CommandLineVersionAction::canUndo() {
  return true;
}

bool CommandLineVersionAction::shouldUndo() {
  return true;
}

const string CommandLineVersionAction::getName() {
  return NAME;
}
