/*
 * FastParsingAction.cpp
 *
 *  Created on: May 9, 2010
 *      Author: heber
 */

#include "Helpers/MemDebug.hpp"

#include "Actions/CmdAction/FastParsingAction.hpp"
#include "Actions/ActionRegistry.hpp"
#include "config.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"
#include "Actions/ValueStorage.hpp"

// memento to remember the state when undoing

class CommandLineFastParsingState : public ActionState {
public:
  CommandLineFastParsingState(bool _bool) :
    boolean(_bool)
  {}
  bool boolean;
};


const char CommandLineFastParsingAction::NAME[] = "fastparsing";

CommandLineFastParsingAction::CommandLineFastParsingAction() :
  Action(NAME)
{}

CommandLineFastParsingAction::~CommandLineFastParsingAction()
{}

void CommandFastParsing(bool fastparsing) {
  ValueStorage::getInstance().setCurrentValue(CommandLineFastParsingAction::NAME, fastparsing);
  ActionRegistry::getInstance().getActionByName(CommandLineFastParsingAction::NAME)->call(Action::NonInteractive);
};

Dialog* CommandLineFastParsingAction::fillDialog(Dialog *dialog) {
  ASSERT(dialog,"No Dialog given when filling action dialog");

  dialog->queryBoolean(NAME, MapOfActions::getInstance().getDescription(NAME));

  return dialog;
}

Action::state_ptr CommandLineFastParsingAction::performCall() {

  config *configuration = World::getInstance().getConfig();
  ValueStorage::getInstance().queryCurrentValue(NAME, configuration->FastParsing);
  if (configuration->FastParsing)
    DoLog(0) && (Log() << Verbose(0) << "I won't parse trajectories." << endl);
  else
    DoLog(0) && (Log() << Verbose(0) << "I will parse trajectories." << endl);
  return Action::success;
}

Action::state_ptr CommandLineFastParsingAction::performUndo(Action::state_ptr _state) {
  CommandLineFastParsingState *state = assert_cast<CommandLineFastParsingState*>(_state.get());

  config *configuration = World::getInstance().getConfig();
  configuration->FastParsing = state->boolean;

  return Action::state_ptr(new CommandLineFastParsingState(!state->boolean));
}

Action::state_ptr CommandLineFastParsingAction::performRedo(Action::state_ptr _state){
  performUndo(_state);
}

bool CommandLineFastParsingAction::canUndo() {
  return true;
}

bool CommandLineFastParsingAction::shouldUndo() {
  return true;
}

const string CommandLineFastParsingAction::getName() {
  return NAME;
}
