/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * RandomNumberDistribution_ParametersTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

#include "RandomNumbers/RandomNumberDistribution_Parameters.hpp"

TextDialog::RandomNumberDistribution_ParametersTextQuery::RandomNumberDistribution_ParametersTextQuery(Parameter<RandomNumberDistribution_Parameters> &_param, std::string title, std::string _description) :
    Dialog::TQuery<RandomNumberDistribution_Parameters>(_param, title,_description)
{}

TextDialog::RandomNumberDistribution_ParametersTextQuery::~RandomNumberDistribution_ParametersTextQuery() {}

bool TextDialog::RandomNumberDistribution_ParametersTextQuery::handle() {
  bool badInput = false;
  do{
    badInput = false;
    std::cout << getDescription() << ": " << std::endl;
    std::cout << "Please enter parameters as follows: 'p=0.5;'";
    std::cout << "Empty line terminates." << std::endl;
    std::cin >> temp;
    if(std::cin.fail()){
      badInput = true;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      std::cout << "Input was not a number!" << std::endl;
      continue;
    }

  } while(badInput);
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  return true;
}


