/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * BooleanTextQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <iostream>

#include "TextUI/Query/TextQuery.hpp"

#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"


TextDialog::BooleanTextQuery::BooleanTextQuery(Parameter<bool> &_param, std::string title, std::string _description) :
    Dialog::TQuery<bool>(_param, title,_description)
{}

TextDialog::BooleanTextQuery::~BooleanTextQuery() {}

bool TextDialog::BooleanTextQuery::handle() {
  bool badInput = false;
  char input = ' ';
  do{
    badInput = false;
    std::cout << getDescription() << "[y/n]: ";
    std::cin >> input;
    if ((input == 'y' ) || (input == 'Y')) {
      temp = true;
    } else if ((input == 'n' ) || (input == 'N')) {
      temp = false;
    } else {
      badInput=true;
      std::cin.clear();
      std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
      std::cout << "Input was not of [yYnN]!" << std::endl;
    }
  } while(badInput);
  // clear the input buffer of anything still in the line
  std::cin.ignore(std::numeric_limits<streamsize>::max(),'\n');
  return true;
}

