/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * UnsignedIntsCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::UnsignedIntsCommandLineQuery::UnsignedIntsCommandLineQuery(Parameter<std::vector<unsigned int> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<unsigned int> >(_param, title, _description)
{}

CommandLineDialog::UnsignedIntsCommandLineQuery::~UnsignedIntsCommandLineQuery() {}

bool CommandLineDialog::UnsignedIntsCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temp = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<unsigned int> >();
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing integers for " << getTitle() << ".");
    return false;
  }
}

