/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C) 2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FilesCommandLineQuery.cpp
 *
 *  Created on: May 21, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"

CommandLineDialog::FilesCommandLineQuery::FilesCommandLineQuery(Parameter<std::vector< boost::filesystem::path> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<boost::filesystem::path> >(_param, title, _description)
{}

CommandLineDialog::FilesCommandLineQuery::~FilesCommandLineQuery() {}

bool CommandLineDialog::FilesCommandLineQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temp = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<boost::filesystem::path> >();
    return true;
  } else {
    ELOG(1, "CommandLineUI parsing error: Missing string for " << getTitle() << ".");
    return false;
  }
}

